function dimer_demo()
global xmin  dmin smin gmin hump
global foundmin flag

% Pairwise transition rates are given by 
% rate = prefmin * prefsad * exp(-(Vsad - Vmin)/T)


flag = 1;

if flag == 1
    xmin = [-2,1; 2,1; 0,-2];
    dmin = [-5, -4.5, -3.5]';
    smin = [0.5, 0.5, 0.5]'; 
    gmin = [0.3, 0.3, 0.7]';
    hump = [0.2, -1, 1, 2, 2];
end

if flag == 2
    xmin = [-2,1; 2,1; 0,-2]; 
    dmin = [-3.5, -4, -5]';
    smin = [0.25, 0.25, 0.15]';
    gmin = [0.5, 0.5, 0.5]';
    hump = [0.2, -1, 1, 2, 1];
end

 flag = 0;

ivals = xmin; % initial guesses for the minima
ni = length(ivals);
foundmin = zeros(ni,5);
foundmin(:,1) = [1;2;3];
for j = 1 : ni
    [mi(j,:),fval] = fminsearch(@mypot1,ivals(j,:));
    eval = myhess(mi(j,1),mi(j,2));
    foundmin(j,2) = fval;
    foundmin(j,3) = sqrt(eval(1)*eval(2));
    foundmin(j,4:5) = mi(j,:);
    fprintf('j=%d, vmin = %d,pref = %d\n',j,fval,foundmin(j,3));
end
nmin = ni;

xylim=2.5;
step=0.05;

n1=100;

x = zeros(n1,1);
y = zeros(n1,1);
xii = [-xylim:step:xylim];
yii = [-xylim:step:xylim];
[xi yi] = meshgrid(xii,yii);


figure;
hold on;
grid
v = mypot(xi,yi);
vmin = min(min(v));
vmax = max(max(v));
contour(xi,yi,v,vmin:0.2:vmax);
plot(mi(:,1),mi(:,2),'.r','Markersize',10);
set(gca,'Fontsize',20);
xlabel('x','Fontsize',20);
ylabel('y','fontsize',20);
daspect([1,1,1])


%% Shrinking Dimer Method
[s1,d1] = mep(1,2);
[s2,d2] = mep(1,3);
[s3,d3] = mep(2,3);
% initial guesses for saddles
isvals = [s1;s2;s3];

% initial guesses for the direction of the dimer
dir = [d1;d2;d3];

ni = length(isvals);
sad = zeros(ni,4);
sad(:,1:2) = [1,2;1,3;2,3];
for j = 1 : ni
    [mi(j,:),fval] = findsaddle(isvals(j,:),dir(j,:));
    eval = sort(myhess(mi(j,1),mi(j,2)),'ascend');
    sad(j,3) = fval;
    % use Langer's formula for prefactors:  r =
    % (1/2*pi)*(det(H_min)/det(H_sad))^(1/2)*omega*exp(-(V_sad-V_min)/T)
    % - omega = the only negative eval of Hess
    fprintf('eval1 = %d\teval2 = %d\n',eval(1),eval(2));
    sad(j,4) = sqrt(abs(eval(1)/eval(2)))*0.5/pi;
    fprintf('i = %d, j = %d, vsad = %d, pref = %d\n',...
        sad(j,1),sad(j,2),sad(j,3),sad(j,4));
end
plot(mi(:,1),mi(:,2),'.b','Markersize',10);

%%

for j = 1:ni
    fprintf('%d\t%d\t%.16e\t%.16e\n',sad(j,1),sad(j,2),sad(j,3),sad(j,4));
end

for j = 1:nmin
    fprintf('%d\t%.16e\t%.16e\n',foundmin(j,1),foundmin(j,2),foundmin(j,3));
end

end
%%  The potential function and its gradient
function v = mypot(x,y)
global xmin  dmin smin gmin hump
v = fe(hump(1),hump(2),hump(3),hump(4),hump(5),x,y);
for j = 1 : 3
    v = v + fe(xmin(j,1),xmin(j,2),dmin(j),smin(j),gmin(j),x,y);
end
end

function v = mypot1(x)
global xmin  dmin smin gmin hump
for j = 1 : 3
    aux(j) = fe(xmin(j,1),xmin(j,2),dmin(j),smin(j),gmin(j),x(1),x(2));
end
v = sum(aux) + fe(hump(1),hump(2),hump(3),hump(4),hump(5),x(1),x(2));
end

function [vx vy] = mygrad(x,y)
global xmin  dmin smin gmin hump
ex = fe(hump(1),hump(2),hump(3),hump(4),hump(5),x,y);
vx = -2*hump(4)*(x - hump(1)).*ex;
vy = -2*hump(5)*(y - hump(2)).*ex;
for j = 1 : 3
    ex = fe(xmin(j,1),xmin(j,2),dmin(j),smin(j),gmin(j),x,y);
    vx = vx - 2*smin(j)*(x - xmin(j,1)).*ex;
    vy = vy - 2*gmin(j)*(y - xmin(j,2)).*ex;
end
end

function dv = mygrad1(x)
global xmin  dmin smin gmin hump
for j = 1 : 3
    ex = fe(xmin(j,1),xmin(j,2),dmin(j),smin(j),gmin(j),x(1),x(2));
    aux(j,1) = -2*smin(j)*(x(1) - xmin(j,1)).*ex;
    aux(j,2) = -2*gmin(j)*(x(2) - xmin(j,2)).*ex;
end
ex = fe(hump(1),hump(2),hump(3),hump(4),hump(5),x(1),x(2));
vx = -2*hump(4)*(x(1) - hump(1)).*ex + sum(aux(:,1));
vy = -2*hump(5)*(x(2) - hump(2)).*ex + sum(aux(:,2));
dv = [vx; vy];
end
%% The shringking dimer method for finding saddles
function [x, val] = findsaddle(x0, dir)
global xmin  dmin smin gmin
global flag
mytol = 1e-4;
nor = norm(mygrad1(x0));
v = dir';
x = x0';
h = 0.01;
len = 0.5;
a = 1.5;
k = 0;
while nor > mytol
    x1 = x(1)+(a-1)*len*v(1);
    x2 = x(1)+(a-2)*len*v(1);
    y1 = x(2)+(a-1)*len*v(2);
    y2 = x(2)+(a-2)*len*v(2);
    plot([x1 x2],[y1 y2]); drawnow;
    if flag == 0 & mod(k,200) == 0 
        fprintf('k = %d\tnor = %d\n',k,nor);

    end
    k = k + 1;
    f1 = -mygrad1(x + (a-1)*len*v);
    f2 = -mygrad1(x + (a-2)*len*v);
    fa = (2-a)*f1 + (a-1)*f2;
    x = x + h*(1-2*v*v')*fa;
    vnew = v + h*(f1 - f2)*(1/len);
    v = vnew/norm(vnew);
    len = len/(1 + h);
    nor = norm(mygrad1(x));
end
val = mypot1(x);
end
%%
function eval = myhess(x,y);
global xmin  dmin smin gmin hump
for j = 1 : 3
    ex = fe(xmin(j,1),xmin(j,2),dmin(j),smin(j),gmin(j),x,y);
    aux(j,1) = (4*smin(j)*(x - xmin(j,1)).^2 - 2*smin(j)).*ex;
    aux(j,2) = (4*gmin(j)*(y - xmin(j,2)).^2 - 2*gmin(j)).*ex;
    aux(j,3) = 4*smin(j)*gmin(j)*(x - xmin(j,1)).*(y - xmin(j,2)).*ex;
end
ex = fe(hump(1),hump(2),hump(3),hump(4),hump(5),x,y);
vxx = sum(aux(:,1)) + (4*hump(4)^2*(x - hump(1)).^2 - 2*hump(4)).*ex;
vyy = sum(aux(:,2)) + (4*hump(5)^2*(y - hump(2)).^2 - 2*hump(4)).*ex;
vxy = sum(aux(:,3)) + 4*hump(4)*hump(5)*(y - hump(2)).*(x - hump(1)).*ex;
H = [vxx, vxy; vxy, vyy];
eval = sort(eig(H),'ascend');
end
%%
function f = fe(x1,y1,d1,s1,g1,x,y)
f = d1*exp(-(s1*(x - x1).^2 + g1*(y - y1).^2));
end

%% The string method

function [guess, dir] = mep(ia,ib)
global foundmin flag
xa = foundmin(ia,4); ya = foundmin(ia,5);
xb = foundmin(ib,4); yb = foundmin(ib,5); 

n1 = 40;

x=linspace(xa,xb,n1)';
y=linspace(ya,yb,n1)';
flag

if flag == 0
    icurve = plot(x,y,'linewidth',1.0,'color','r');
    drawnow;
end
xn = x;
yn = y;
g1 = linspace(0,1,n1)';

ep = 1.0e-3;
s = 0.002;
shift = 10;
while shift > ep
    [vx vy] = mygrad(x,y); 
    xn(2:n1-1) = x(2:n1-1)-s*vx(2:n1-1);
    yn(2:n1-1) = y(2:n1-1)-s*vy(2:n1-1);
    %reparametrization
    dx = xn - circshift(xn,[1,0]);
    dy = yn - circshift(yn,[1,0]);
    dx(1) = 0;
    dy(1) = 0;
    sqxy = sqrt(dx.^2+dy.^2);
    lxy = cumsum(sqxy);
    abxy = lxy(n1);
    lxy = lxy/abxy;
    xn = interp1(lxy,xn,g1);
    yn = interp1(lxy,yn,g1);
    shift = norm([x-xn; y-yn]);
    x = xn;
    y = yn;
    if flag == 0
        set(icurve,'xdata',x,'ydata',y);
        drawnow;
    end
end
if flag == 0
    set(icurve,'xdata',x,'ydata',y);
    drawnow;
end
[csort, isort] = sort(mypot(x,y),'descend');
guess = [0.5*(x(isort(1)) + x(isort(2))), 0.5*(y(isort(1)) + y(isort(2)))];
dir = [x(isort(1)) - x(isort(2)), y(isort(1)) - y(isort(2))];
end

