function dimer_demo1()
global xmin  dmin smin gmin hump
global foundmin flag

% Pairwise transition rates are given by 
% rate = prefmin * prefsad * exp(-(Vsad - Vmin)/T)


flag = 1;

if flag == 1
    xmin = [-2,1; 2,1; 0,-2];
    dmin = [-5, -4.5, -3.5]';
    smin = [0.5, 0.5, 0.5]'; 
    gmin = [0.3, 0.3, 0.7]';
    hump = [0.2, -1, 1, 2, 2];
end

if flag == 2
    xmin = [-2,1; 2,1; 0,-2]; 
    dmin = [-3.5, -4, -5]';
    smin = [0.25, 0.25, 0.15]';
    gmin = [0.5, 0.5, 0.5]';
    hump = [0.2, -1, 1, 2, 1];
end

 flag = 0;

ivals = xmin; % initial guesses for the minima
ni = length(ivals);
foundmin = zeros(ni,5);
foundmin(:,1) = [1;2;3];
for j = 1 : ni
    [mi(j,:),fval] = fminsearch(@mypot1,ivals(j,:));
    eval = sort(eig(myhess(mi(j,1),mi(j,2))),'ascend');
    foundmin(j,2) = fval;
    foundmin(j,3) = sqrt(eval(1)*eval(2));
    foundmin(j,4:5) = mi(j,:);
    fprintf('j=%d, vmin = %d,pref = %d\n',j,fval,foundmin(j,3));
end
nmin = ni;

xylim=2.5;
step=0.05;

n1=100;

x = zeros(n1,1);
y = zeros(n1,1);
xii = [-xylim:step:xylim];
yii = [-xylim:step:xylim];
[xi yi] = meshgrid(xii,yii);


figure;
hold on;
grid
v = mypot(xi,yi);
vmin = min(min(v));
vmax = max(max(v));
contour(xi,yi,v,vmin:0.2:vmax);
plot(mi(:,1),mi(:,2),'.r','Markersize',20);
set(gca,'Fontsize',20);
xlabel('x','Fontsize',20);
ylabel('y','fontsize',20);
daspect([1,1,1])


%% Shrinking Dimer Method
for xstart = -2.0 : 1.0 : 2.0
    for ystart = -2.0 : 1.0 : 2.0
        x0 = [xstart; ystart];
        [evec ee] = eig(myhess(xstart,ystart));
        [esort, isort] = sort(diag(ee),'ascend');
        evec = evec(:,isort);
        dir = evec(:,1);

        mytol = 1e-4;
        nor = norm(mygrad1(x0));
        v = dir;
        x = x0;
        h = 0.01;
        len = 0.5;
        a = 1.5;
        k = 0;
        x1 = x(1)+(a-1)*len*v(1);
        x2 = x(1)+(a-2)*len*v(1);
        y1 = x(2)+(a-1)*len*v(2);
        y2 = x(2)+(a-2)*len*v(2);
        plot([x1 x2],[y1 y2],'r','Linewidth',1);
        myplot = plot([x1 x2],[y1 y2],'Linewidth',1);
        drawnow;

        while nor > mytol & max(abs(x)) < 2.5
            x1 = x(1)+(a-1)*len*v(1);
            x2 = x(1)+(a-2)*len*v(1);
            y1 = x(2)+(a-1)*len*v(2);
            y2 = x(2)+(a-2)*len*v(2);
            set(myplot,'Xdata',[x1 x2],'Ydata', [y1 y2]);
            axis([-xylim,xylim,-xylim,xylim]);
            drawnow;
            k = k + 1;
            f1 = -mygrad1(x + (a-1)*len*v);
            f2 = -mygrad1(x + (a-2)*len*v);
            fa = (2-a)*f1 + (a-1)*f2;
            x = x + h*(1-2*v*v')*fa;
            vnew = v + h*(f1 - f2)*(1/len);
            v = vnew/norm(vnew);
            len = len/(1 + h);
            nor = norm(mygrad1(x));
        end
        if nor <= mytol % if a saddle is found
            fval = mypot1(x);
            fprintf('saddle: (%d, %d),\t V_sad = %d\n',x(1),x(2),fval);
            eval = sort(eig(myhess(x(1),x(2))),'ascend');
            % use Langer's formula for prefactors:  r =
            % (1/2*pi)*(det(H_min)/det(H_sad))^(1/2)*omega*exp(-(V_sad-V_min)/T)
            % - omega = the only negative eval of Hess
            fprintf('eval1 = %d\teval2 = %d\n',eval(1),eval(2));
            sad(j,4) = sqrt(abs(eval(1)/eval(2)))*0.5/pi;
            fprintf('i = %d, j = %d, vsad = %d, pref = %d\n',...
                sad(j,1),sad(j,2),sad(j,3),sad(j,4));
            plot(x(1),x(2),'.b','Markersize',20);
        end
    end
end

%%
function v = mypot(x,y)
global xmin  dmin smin gmin hump
v = fe(hump(1),hump(2),hump(3),hump(4),hump(5),x,y);
for j = 1 : 3
    v = v + fe(xmin(j,1),xmin(j,2),dmin(j),smin(j),gmin(j),x,y);
end


function v = mypot1(x)
global xmin  dmin smin gmin hump
for j = 1 : 3
    aux(j) = fe(xmin(j,1),xmin(j,2),dmin(j),smin(j),gmin(j),x(1),x(2));
end
v = sum(aux) + fe(hump(1),hump(2),hump(3),hump(4),hump(5),x(1),x(2));


function [vx vy] = mygrad(x,y)
global xmin  dmin smin gmin hump
ex = fe(hump(1),hump(2),hump(3),hump(4),hump(5),x,y);
vx = -2*hump(4)*(x - hump(1)).*ex;
vy = -2*hump(5)*(y - hump(2)).*ex;
for j = 1 : 3
    ex = fe(xmin(j,1),xmin(j,2),dmin(j),smin(j),gmin(j),x,y);
    vx = vx - 2*smin(j)*(x - xmin(j,1)).*ex;
    vy = vy - 2*gmin(j)*(y - xmin(j,2)).*ex;
end

function dv = mygrad1(x)
global xmin  dmin smin gmin hump
for j = 1 : 3
    ex = fe(xmin(j,1),xmin(j,2),dmin(j),smin(j),gmin(j),x(1),x(2));
    aux(j,1) = -2*smin(j)*(x(1) - xmin(j,1)).*ex;
    aux(j,2) = -2*gmin(j)*(x(2) - xmin(j,2)).*ex;
end
ex = fe(hump(1),hump(2),hump(3),hump(4),hump(5),x(1),x(2));
vx = -2*hump(4)*(x(1) - hump(1)).*ex + sum(aux(:,1));
vy = -2*hump(5)*(x(2) - hump(2)).*ex + sum(aux(:,2));
dv = [vx; vy];

%%
function H = myhess(x,y);
global xmin  dmin smin gmin hump
for j = 1 : 3
    ex = fe(xmin(j,1),xmin(j,2),dmin(j),smin(j),gmin(j),x,y);
    aux(j,1) = (4*smin(j)*(x - xmin(j,1)).^2 - 2*smin(j)).*ex;
    aux(j,2) = (4*gmin(j)*(y - xmin(j,2)).^2 - 2*gmin(j)).*ex;
    aux(j,3) = 4*smin(j)*gmin(j)*(x - xmin(j,1)).*(y - xmin(j,2)).*ex;
end
ex = fe(hump(1),hump(2),hump(3),hump(4),hump(5),x,y);
vxx = sum(aux(:,1)) + (4*hump(4)^2*(x - hump(1)).^2 - 2*hump(4)).*ex;
vyy = sum(aux(:,2)) + (4*hump(5)^2*(y - hump(2)).^2 - 2*hump(4)).*ex;
vxy = sum(aux(:,3)) + 4*hump(4)*hump(5)*(y - hump(2)).*(x - hump(1)).*ex;
H = [vxx, vxy; vxy, vyy];
%eval = sort(eig(H),'ascend');

%%
function f = fe(x1,y1,d1,s1,g1,x,y)
f = d1*exp(-(s1*(x - x1).^2 + g1*(y - y1).^2));


