function mep_7well()
% Finds MEPs between each pair of local minima in the 7-well potential
% using the string method (E, Ren, Vanden-Eijnden, 2002, 2006)
n1 = 100; % the number of images along the string
%% find 7 minima
% initial guesses for the local minima
ivals = [1 1; -1 2; -1 0; 0 0; 0 -1; 2 -1.5; -2 -2];
for j = 1 : length(ivals)
    [mi(j,:),fval] = fminsearch(@mypot1,ivals(j,:));
    fprintf('j=%d\t vmin=%d\n',j,fval);
end

%% set up graphics
figure;
hold on;
grid

xylim=2.5;
step=0.05;

xii = [-xylim:step:xylim];
yii = [-xylim:step:xylim];
[xi yi]  =meshgrid(xii,yii);
v = mypot(xi,yi);
vmin = min(min(v));
contour(xi,yi,v,vmin : 1 : 6);
x = zeros(n1,1);
y = zeros(n1,1);
set(gca,'Fontsize',20);
xlabel('x','Fontsize',20);
ylabel('y','fontsize',20);
daspect([1,1,1])
%% find MEPs between each pair of minima
tol = 1.0e-5; % tolerance
s = 2e-3; % step of the string method
for ia = 1 : 6  % index of min a
    for ib = ia + 1 : 7 %index of min b
        xa = mi(ia,1); ya = mi(ia,2);
        xb = mi(ib,1); yb = mi(ib,2);
        % initial path is a segment of a straight line
        x = linspace(xa,xb,n1)';
        y = linspace(ya,yb,n1)';
        curve = plot(x,y,'linewidth',2.0,'color','r');
        xn = x;
        yn = y;
        g1 = linspace(0,1,n1)';        
        % The string method
        shift = Inf;
        while shift > tol
            % gradient descent
            [vx vy] = mygrad(x,y); 
            xn(2:n1-1) = x(2:n1-1)-s*vx(2:n1-1);
            yn(2:n1-1) = y(2:n1-1)-s*vy(2:n1-1);
            %reparametrization
            dx = xn - circshift(xn,[1,0]);
            dy = yn - circshift(yn,[1,0]);
            dx(1) = 0;
            dy(1) = 0;
            sqxy = sqrt(dx.^2+dy.^2); % distances between the images
            lxy = cumsum(sqxy); % the arclengths from xa to all of the images
            abxy = lxy(n1); % the length of the path from xa to xb
            lxy = lxy/abxy; % normalized arclengths
            xn = interp1(lxy,xn,g1);
            yn = interp1(lxy,yn,g1);
            shift = norm([x-xn; y-yn]); % total displacement
            x = xn;
            y = yn;
            set(curve,'xdata',x,'ydata',y) 
            drawnow
        end
        fprintf('saddle(%d,%d): v = %d\n',ia,ib,max(mypot(x,y)));
    end
end
end
%% potential and its graduent
function v=mypot(x,y)
aux1 = x-cos(pi*y);
aux2 = y-cos(pi*x);
v = x.^4+y.^4-2*aux1.^2-2*aux2.^2+x;
end

function v = mypot1(x)
aux1 = x(1)-cos(pi*x(2));
aux2 = x(2)-cos(pi*x(1));
v = x(1).^4+x(2).^4-2*aux1.^2-2*aux2.^2+x(1);
end

function [vx vy] = mygrad(x,y)
aux1 = x-cos(pi*y);
aux2 = y-cos(pi*x);
vx = 4*(x.^3-aux1-pi*aux2.*sin(pi*x))+1;
vy = 4*(y.^3-aux2-pi*aux1.*sin(pi*y));
end


